﻿using System;
using System.Data.SQLite;
using DataAccess.DataTables;
using DataAccess.DataRows;

namespace DataAccess.TableAdapters
{
    public class ExerciseTableAdapter
    {
        public ExerciseDataTable FillByAll()
        {
            ExerciseDataTable dt = new ExerciseDataTable();
            SQLiteConnection conn = ConnectionProxy.GetConnection();

            try
            {
                conn.Open();
                SQLiteCommand selectAll = new SQLiteCommand(conn);
                selectAll.CommandText = "SELECT * FROM EXERCISE";

                SQLiteDataAdapter da = new SQLiteDataAdapter(selectAll);
                da.Fill(dt);
            }
            catch (SQLiteException ex)
            {
                dt = null;
            }
            finally
            {
                conn.Close();
            }

            return dt;
        }

        public bool InsertExercise(int steps)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand insert = new SQLiteCommand(conn);
                insert.CommandText = "INSERT INTO EXERCISE (TOTAL_STEPS, DATE) VALUES(" + steps + ",date('now'))";

                if (insert.ExecuteNonQuery() < 1)
                {
                    throw new Exception("Error inserting in to EXERCISE table.");
                }
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            return success;
        }
    }
}